/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// Procedural Burning Fire
// By Brandon Fogerty
// bfogerty at gmail dot com
// Special Thanks Inigo Quilez

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

#define FlameSpeed 	0.4

#define Time 		time * FlameSpeed
#define Resolution 	resolution

#define ColorScale	0.45
#define Color0		vec3( 0.1, 0.1, 0.3 )     * ColorScale
#define Color1		vec3( 0.7, 0.4, 0.2 )     * ColorScale
#define Color2		vec3( 0.4, 0.15, 0.15 )   * ColorScale
#define Color3		vec3( 0.2, 0.15, 0.15 )   * ColorScale
#define Color4		vec3( 0.15, 0.15, 0.15 )  * ColorScale
#define Color5		vec3( 0.10, 0.10, 0.10 )  * ColorScale


float hash( float x )
{
    return fract( sin( x ) * 43758.5453 );
}

float noise( vec2 uv )
{
    vec3 x = vec3( uv.xy, 0.0 );
    
    vec3 p = floor( x );
    vec3 f = fract( x );
    
    f = f*f*(3.0 - 2.0*f);
    
    float n = dot( p, vec3(1.0, 57.0, 113.0) );
    
    return mix(	mix(	mix( hash( n + 0.0 ), 	hash( n + 1.0 ), f.x ),
        				mix( hash( n + 57.0), 	hash( n + 58.0), f.x ), f.y ),
				mix(	mix( hash( n + 113.0), 	hash( n + 114.0), f.x),
                    	mix( hash( n + 170.0), 	hash( n + 171.0), f.x), f.y), f.z);
}


float perlinNoise( vec2 uv )
{
    
    vec2 uv1 = uv + vec2( 0.0, -Time * 0.1 );
    vec2 uv2 = uv + vec2( cos(-Time) * 7.0, -Time * 0.5 );
    vec2 uv3 = uv + vec2( 0.0, -Time * 0.4 );
    vec2 uv4 = uv + vec2( sin(-Time * 2.0), -Time * 0.2 );
	
    float n = 		noise( uv1 * 1.0 ) 	* 128.0 +
        		noise( uv1 * 2.0 ) 	* 64.0 +
        		noise( uv1 * 4.0 ) 	* 32.0 +
        		noise( uv * 8.0 ) 	* 16.0 +
        		noise( uv * 16.0 ) 	* 8.0 +
        		noise( uv4 * 32.0 ) 	* 4.0 +
        		noise( uv4 * 64.0 ) 	* 2.0 +
        		noise( uv * 128.0 ) * 1.0;
    
    
    return 	n / ( 1.0 + 2.0 + 4.0 + 8.0 + 16.0 + 32.0 + 64.0 + 128.0 );
}

float fBm( vec2 uv )
{
    float mag = 0.0;
    float freq = 4.0;
    
    for( int i = 0; i < 6; ++i )
    {
	uv = uv + vec2( 0.0, -Time * 2.0 );
        mag += abs(perlinNoise( uv * freq ) - 0.5) * 2.0/freq;
        freq *= 0.5;
    }
    
    return mag;
}



vec3 blendColor( vec2 uv, vec3 color0, vec3 color1, float scalar, float minLimit, float maxLimit )
{
	if( uv.y < minLimit || uv.y >= maxLimit )
	{
		return vec3( 0.0, 0.0, 0.0 );
	}
	
	float t = ( uv.y - minLimit ) / ( maxLimit - minLimit );
	return mix( color0 * scalar, color1 * scalar, t );
}

float shape( vec2 uv )
{
	return clamp( sin(uv.x * 3.0)*2.0 - (uv.y+0.70), 0.0, 1.0 );
}

void main(void)
{
	vec2 uv = scaled_gl_FragCoord.xy / Resolution.xy;
	uv.x *= (Resolution.x / Resolution.y);
    
    	float c = fBm( uv * 5.0 ) * shape( uv );
	
	vec3 finalColor = vec3( 0.0, 0.0, 0.0 );
	finalColor =  blendColor( uv, Color0, Color1, c,  0.00, 0.30 );
	finalColor += blendColor( uv, Color1, Color2, c,  0.30, 0.60 );
	finalColor += blendColor( uv, Color2, Color3, c,  0.60, 0.70 );
	finalColor += blendColor( uv, Color3, Color4, c,  0.70, 0.80 );
	finalColor += blendColor( uv, Color4, Color5, c,  0.80, 1.00 );
	finalColor *= pow( c, 1.3 );
	
	gl_FragColor = vec4( finalColor, 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}